/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.optifine.Config;
import net.optifine.render.MultiTextureData;
import net.optifine.render.SpriteRenderData;
import net.optifine.util.IntArray;
import net.optifine.util.TextureUtils;

public class MultiTextureBuilder {
    private int vertexCount;
    private faa blockLayer;
    private fke[] quadSprites;
    private boolean reorderingAllowed;
    private boolean[] drawnIcons = new boolean[256];
    private List<SpriteRenderData> spriteRenderDatas = new ArrayList();
    private IntArray vertexPositions = new IntArray(16);
    private IntArray vertexCounts = new IntArray(16);

    public MultiTextureData build(int vertexCountIn, faa blockLayerIn, fke[] quadSpritesIn, int[] quadOrderingIn) {
        if (quadSpritesIn == null) {
            return null;
        }
        this.vertexCount = vertexCountIn;
        this.blockLayer = blockLayerIn;
        this.quadSprites = quadSpritesIn;
        this.reorderingAllowed = !this.blockLayer.isNeedsSorting();
        int maxTextureIndex = Config.getTextureMap().getCountRegisteredSprites();
        if (this.drawnIcons.length <= maxTextureIndex) {
            this.drawnIcons = new boolean[maxTextureIndex + 1];
        }
        Arrays.fill(this.drawnIcons, false);
        this.spriteRenderDatas.clear();
        int texSwitch = 0;
        int grassOverlayIndex = -1;
        int countQuads = this.vertexCount / 4;
        for (int i2 = 0; i2 < countQuads; ++i2) {
            int iconIndex;
            int is = quadOrderingIn != null ? quadOrderingIn[i2] : i2;
            fke icon = this.quadSprites[is];
            if (icon == null || this.drawnIcons[iconIndex = icon.getIndexInMap()]) continue;
            if (icon == TextureUtils.iconGrassSideOverlay) {
                if (grassOverlayIndex >= 0) continue;
                grassOverlayIndex = i2;
                continue;
            }
            i2 = this.drawForIcon(icon, i2, quadOrderingIn) - 1;
            ++texSwitch;
            if (!this.reorderingAllowed) continue;
            this.drawnIcons[iconIndex] = true;
        }
        if (grassOverlayIndex >= 0) {
            this.drawForIcon(TextureUtils.iconGrassSideOverlay, grassOverlayIndex, quadOrderingIn);
            ++texSwitch;
        }
        SpriteRenderData[] srds = this.spriteRenderDatas.toArray(new SpriteRenderData[this.spriteRenderDatas.size()]);
        return new MultiTextureData(srds);
    }

    private int drawForIcon(fke sprite, int startQuadPos, int[] quadOrderingIn) {
        this.vertexPositions.clear();
        this.vertexCounts.clear();
        int firstRegionEnd = -1;
        int lastPos = -1;
        int countQuads = this.vertexCount / 4;
        for (int i2 = startQuadPos; i2 < countQuads; ++i2) {
            int is = quadOrderingIn != null ? quadOrderingIn[i2] : i2;
            fke ts = this.quadSprites[is];
            if (ts == sprite) {
                if (lastPos >= 0) continue;
                lastPos = i2;
                continue;
            }
            if (lastPos < 0) continue;
            this.draw(lastPos, i2);
            if (!this.reorderingAllowed) {
                this.spriteRenderDatas.add(new SpriteRenderData(sprite, this.vertexPositions.toIntArray(), this.vertexCounts.toIntArray()));
                return i2;
            }
            lastPos = -1;
            if (firstRegionEnd >= 0) continue;
            firstRegionEnd = i2;
        }
        if (lastPos >= 0) {
            this.draw(lastPos, countQuads);
        }
        if (firstRegionEnd < 0) {
            firstRegionEnd = countQuads;
        }
        this.spriteRenderDatas.add(new SpriteRenderData(sprite, this.vertexPositions.toIntArray(), this.vertexCounts.toIntArray()));
        return firstRegionEnd;
    }

    private void draw(int startQuadVertex, int endQuadVertex) {
        int vxQuadCount = endQuadVertex - startQuadVertex;
        if (vxQuadCount <= 0) {
            return;
        }
        int startVertex = startQuadVertex * 4;
        int vxCount = vxQuadCount * 4;
        this.vertexPositions.put(startVertex);
        this.vertexCounts.put(vxCount);
    }
}

